import asyncio
import logging
import json
from src.config import Config
from src.api_utils import APIClient
from src.evaluation import Evaluator

logging.basicConfig(level=logging.INFO)

async def main():
    cfg = Config()
    api_client = APIClient(cfg)
    evaluator = Evaluator(api_client)

    # Load graph and ground truth
    graph_file = "entity_graphs/Stephen_King.json"
    gt_file = "data/stephen_king_gt.txt"

    with open(graph_file, "r") as f:
        graph = json.load(f)
    
    generated_triples = [(subj, rel, obj) for subj, edges in graph.items() for rel, obj in edges]

    with open(gt_file, "r") as f:
        ground_truth_text = f.read()

    ground_truth_triples = await evaluator.extract_triples(ground_truth_text)
    
    matches, mismatches = evaluator.match_triples(generated_triples, ground_truth_triples)
    metrics = evaluator.compute_metrics(generated_triples, ground_truth_triples, matches)

    logging.info(f"Evaluation Results:\nPrecision: {metrics['precision']:.4f}\nRecall: {metrics['recall']:.4f}\nF1-score: {metrics['f1']:.4f}")

if __name__ == "__main__":
    asyncio.run(main())
